// server.js
const express = require('express');
const dotenv = require('dotenv');
const apiRoutes = require('./routes/api');

dotenv.config();

const app = express();
const port = process.env.PORT || 3000;

app.use(express.json()); // To parse JSON bodies
app.use('/api', apiRoutes); // Mount API routes

app.listen(port, () => {
  console.log(`Server running on port ${port}`);
});
