// controllers/apiController.js
const db = require('../config/db');
const { generateApiKey } = require('../utils');

// Controller to create an API key
exports.createApiKey = async (req, res) => {
  try {
    const userId = req.body.userId;
    const key = generateApiKey();
    const result = await db.execute('INSERT INTO api_keys (user_id, api_key) VALUES (?, ?)', [userId, key]);
    res.status(201).json({ apiKey: key, message: 'API key created successfully.' });
  } catch (err) {
    console.error(err);
    res.status(500).json({ message: 'Error creating API key' });
  }
};

// Controller to get all API keys (admin view)
exports.getApiKeys = async (req, res) => {
  try {
    const [rows] = await db.execute('SELECT * FROM api_keys');
    res.status(200).json({ apiKeys: rows });
  } catch (err) {
    console.error(err);
    res.status(500).json({ message: 'Error fetching API keys' });
  }
};
